/*
 * Decompiled with CFR 0.152.
 */
package Project.Game.Componenets;

import BryceGraphs.ADTs.EditableGNode;
import BryceGraphs.ADTs.GNode;
import BryceGraphs.ADTs.Serials.SerialAdjacencyNode;
import BryceGraphs.gui_components.gui_EditableGNode;
import Data_Structures.Structures.HashingClasses.Dict;
import Data_Structures.Structures.List;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.GUI.Components.small.gui_label;
import Project.Game.rooms.room_main;
import Project.Game.rooms.room_puzzle_level;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;

public class levelButton
extends gui_button
implements SerialAdjacencyNode<levelButton>,
EditableGNode {
    File file;
    List<levelButton> children = new List();
    gui_EditableGNode container;
    int best_player_score;
    final int goal_score;
    gui_label p_score;
    gui_label g_score;

    public levelButton(File file_in, String description_in, int player_score, int goal_score) {
        super(0.0, 0.0, 300, 200);
        this.file = file_in;
        this.setText(description_in);
        this.best_player_score = player_score;
        this.goal_score = goal_score;
        this.p_score = new gui_label(0.0, 0.0, 100, 50);
        this.p_score.setText("" + this.best_player_score);
        this.p_score.fitToContents();
        this.g_score = new gui_label(0.0, 0.0, 100, 50);
        this.g_score.setText("" + goal_score);
        this.g_score.fitToContents();
    }

    @Override
    public void update() {
        super.update();
        if (this.flag()) {
            room_puzzle_level level = new room_puzzle_level(this.file, this);
            this.room_goto(level);
        }
        if (this.container != null) {
            this.container.window.unscroll();
        }
    }

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(this.file);
        stream.println(this.getText());
        stream.println(this.best_player_score);
        stream.println(this.goal_score);
    }

    @Override
    public String getSerialName() {
        return "levelButtonNode";
    }

    public static levelButton deserialize(Iterator<String> stream) {
        File file = new File(stream.next());
        String Description = stream.next();
        int player_score = new Integer(stream.next());
        int goal_score = new Integer(stream.next());
        return new levelButton(file, Description, player_score, goal_score);
    }

    @Override
    public int getNeighborSize() {
        return this.children.size();
    }

    @Override
    public Iterable<levelButton> getNeighbors() {
        return this.children;
    }

    @Override
    public void setNeighbors(Iterable<levelButton> neighbors) {
        this.children.clear();
        this.children.append(neighbors);
    }

    @Override
    public String getGNodeName() {
        return this.getText();
    }

    @Override
    public void getGNodeData(Dict<Object> map) {
        int child_num = 0;
        for (GNode gNode : this.getNeighbors()) {
            map.insert("Child " + child_num, gNode);
            ++child_num;
        }
    }

    @Override
    public void populateEditField(gui_EditableGNode node, int ROW_H) {
        node.add(this);
        this.setX(0.0);
        this.setY(100.0);
        this.setW(node.getW() - 4);
        this.setH(50);
        node.addGNodes(this.getNeighbors());
        this.container = node;
        node.addField("Goal : <", this.g_score);
        node.addField("Player : ", this.p_score);
    }

    public void newScore(int score) {
        if (this.best_player_score == -1 || score < this.best_player_score) {
            this.setPlayerScore(score);
        }
    }

    private void setPlayerScore(int score) {
        this.best_player_score = score;
        this.p_score.setText("" + score);
        this.p_score.fitToContents();
        ((room_main)this.getRoom()).serializeSavedGame();
    }
}

